﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.Scripting;
using UnityEngine.AddressableAssets;
using UnityEngine.ResourceManagement.AsyncOperations;
using UnityEngine.UI;

public class AddressablesSpawner : MonoBehaviour
{
    public IList<GameObject> asteroids;
    public AssetLabelReference asteroidLabel;
    public Button[] asteroidButtons;

    private void Start()
    {
        Addressables.LoadAssetsAsync<GameObject>(asteroidLabel, null).Completed += OnResourcesRetrieved;
    }

    private void OnResourcesRetrieved(AsyncOperationHandle<IList<GameObject>> obj)
    {
        asteroids = obj.Result;

        foreach(var asteroidButton in asteroidButtons)
        {
            asteroidButton.interactable = true;
        }
    }

    public void InstantiateAsteroid(int index)
    {
        if(asteroids != null)
        {
            Vector3 position = Random.insideUnitSphere * 5;
            position.Set(position.x, 0, position.z);

            Instantiate(asteroids[index], position, Quaternion.identity, null);

        }
    }

}
